<?php
    /*
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $gestoreTraduzioni = new GestoreTraduzioni("../localizzazione", array("italiano","inglese","tedesco","francese","spagnolo"));
    $gestoreTraduzioni->caricaTraduzioni();
?>

<form name="formAggiornamentoTraduzioni" action="../controller/controllerTraduzioni.php" method="post">
    <input type="text" class="d-none" name="operazione" value="aggiornaTraduzioni">
    <h4 class="mb-4 title">Traduzioni</h4>
    
    <div class="table-responsive">
         <table class="table table-sm table-borderless">
             <thead>
                <tr>
                    <th scope="col">Stringa</th>
                    <th scope="col">Italiano</th>
                    <th scope="col">Inglese</th>
                    <th scope="col">Tedesco</th>
                    <th scope="col">Francese</th>
                    <th scope="col">Spagnolo</th>
                </tr>
             </thead>
             <tbody>
                 <?php 
                    foreach($stringheDaTradurre as $stringa) {
                    ?>
                    <tr>
                        <th scope="row"><?php echo $stringa ?></th>
                        <th scope="col"><input type="text" name="<?php echo str_replace(array(" ","."),"_",$stringa) ?>-italiano" class="form-control" value="<?php echo $gestoreTraduzioni->traduci($stringa,"italiano") ?>"></th>
                        <th scope="col"><input type="text" name="<?php echo str_replace(array(" ","."),"_",$stringa) ?>-inglese" class="form-control" value="<?php echo $gestoreTraduzioni->traduci($stringa,"inglese") ?>"></th>
                        <th scope="col"><input type="text" name="<?php echo str_replace(array(" ","."),"_",$stringa) ?>-tedesco" class="form-control" value="<?php echo $gestoreTraduzioni->traduci($stringa,"tedesco") ?>"></th>
                        <th scope="col"><input type="text" name="<?php echo str_replace(array(" ","."),"_",$stringa) ?>-francese" class="form-control" value="<?php echo $gestoreTraduzioni->traduci($stringa,"francese") ?>"></th>
                        <th scope="col"><input type="text" name="<?php echo str_replace(array(" ","."),"_",$stringa) ?>-spagnolo" class="form-control" value="<?php echo $gestoreTraduzioni->traduci($stringa,"spagnolo") ?>"></th>
                    </tr>
                    <?php
                    }
                 ?>
             </tbody>
         </table>
     </div>
</form>
            
<div class="footer">
    <button onclick="document.formAggiornamentoTraduzioni.submit()" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
</div>